#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>
#include <tripletToCompressed.h>

#include <mex.h>

static int initialized = 0;
static BLPproblem *problemMex;
static BLPdata *dataMex;

#include<loadData.c>

void mexFunction(int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[]) { 
  int i,m,j,height,length,n;
  int date_market, data_size;
  F_TYPE *arg;
  int argSize;
  F_TYPE *output;
  F_TYPE *Columns_matlab, *Rows_matlab, *Transpose_matlab;
  mwIndex *Jc, *Ir;
  double *target;
  double *jacobianIndexInit;
  double *sizeInit;

  loadData(prhs);

  if(reInit) {
    plhs[0]=mxCreateDoubleMatrix(1, 1, mxREAL);
    output = mxGetPr(plhs[0]);
    output[0]=0;
    return;
  }

  problem=problemMex;
  data=dataMex;

  date_market=problem->market*problem->date;
  data_size = data->index[date_market];
  threadsN = problem->market*problem->date+problem->demoGroups*problem->date;

  height = data->index[problem->market*problem->date]+problem->demoGroups*problem->product+problem->instruments;

  if(problem->doInstruments==1) {
    length = problem->allParams+height;
    if(problem->ar) {
      length++;
    }
  } else {
    length = problem->allParams+height+instrumentsSave;
  }

  plhs[0]=mxCreateDoubleMatrix(1, 1, mxREAL);
  plhs[1]=mxCreateDoubleMatrix((date_market+1), 1, mxREAL);

  jacobianIndexInit = mxGetPr(plhs[1]);  
  sizeInit = mxGetPr(plhs[0]);
  data->jacobianIndex = (int *) mxMalloc((date_market+1)*sizeof(int));
  *sizeInit = getSparseSize(problem, data);
  size = *sizeInit;
  for(i=0;i<=date_market;++i) {
    jacobianIndexInit[i] = data->jacobianIndex[i];
  }

  Rows = (int *) mxMalloc(size*sizeof(int));
  Columns = (int *) mxMalloc(size*sizeof(int));
  plhs[2]=mxCreateDoubleMatrix(size, 1, mxREAL);
  plhs[3]=mxCreateDoubleMatrix(length+1, 1, mxREAL);
  plhs[4]=mxCreateDoubleMatrix(size, 1, mxREAL);
  Rows_matlab = mxGetPr(plhs[2]);
  Columns_matlab = mxGetPr(plhs[3]);
  Transpose_matlab = mxGetPr(plhs[4]);

  createSparseIndex(problem, data);
  tripletToCompressed(size, height, length, Rows, Columns, Rows_matlab, Columns_matlab, Transpose_matlab);

  /* Load indexes */

  n = height;
  m = length;
  plhs[5] = mxCreateSparse(n,m,size,mxREAL);

  Jc = (mwIndex *) mxMalloc((m+1)*sizeof(mwIndex));
  Ir = (mwIndex *) mxMalloc(size*sizeof(mwIndex));
  target = (double *) mxMalloc(size*sizeof(double));

  mxSetIr(plhs[5], Ir);
  mxSetJc(plhs[5], Jc);
  mxSetPr(plhs[5], target);
  for(i=0;i<=m;i++) {
    Jc[i]=Columns_matlab[i];
  }
  for(i=0;i<size;i++) {
    Ir[i]=Rows_matlab[i];
    target[i]=1;
  }
}
