#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>

#include <mex.h>

static int initialized = 0;
static BLPproblem *problemMex;
static BLPdata *dataMex;
static mwIndex *JcStatic;
static mwIndex *IrStatic;
static int *TransposeStatic;

#include<loadDataBin.c>

int main(int argc, char *argv[]) {
  int i,j;
  int date_market, data_size;
  F_TYPE *arg, *mySeedInit;
  int argSize;
  
  F_TYPE *output, *Ird, *Jcd;
  mwIndex *Ir, *Jc;
  double *target, *T;
  int m,n;

  mxArray *mxOut;

  loadData(argc, argv);

  if(argc<3) {
    printf("The executable needs two arguments: output and input .mat file names\n");
    exit(1); 
  }

  char filename[NAME_LENGTH];
  MATFile *mfp;

  strncpy(filename, argv[1], NAME_LENGTH);

  if ((mfp = matOpen(filename, "r")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  problem=problemMex;
  data=dataMex;

  date_market=problem->market*problem->date;
  data_size = data->index[date_market];
  threadsN = problem->market*problem->date;

  /* Initialize random number generator */
  mySeedInit = mxGetPr(readvar(mfp,"mySeed"));
  if(problem->bs) {
    seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));
    
    createGeneratorsSaved(threadsN, mySeedInit, seed);
  } else {
    mySeed = (long *) mxMalloc(4*sizeof(long));
    mySeed[0] = (long) mySeedInit[0];
    mySeed[1] = (long) mySeedInit[1];
    mySeed[2] = (long) mySeedInit[2];
    mySeed[3] = (long) mySeedInit[3];

    seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

    createGenerators(threadsN, mySeed, seed);
  }

  /* Load the starting point */
  arg = mxGetPr(readvar(mfp,"arg"));

  /* Load indexes */
  size = (int) mxGetPr(mxGetField(readvar(mfp,"problem"), 0, "mysize"))[0];
  Ird = mxGetPr(readvar(mfp,"Rows"));
  Jcd = mxGetPr(readvar(mfp,"Columns"));
  T = mxGetPr(readvar(mfp,"Transpose"));
  
  n = data->index[problem->market*problem->date]+problem->demoGroups*problem->product+problem->instruments;

  if(problem->doInstruments==1) {
    m = problem->allParams+n;
    if(problem->ar) {
      m++;
    }
  } else {
    m = problem->allParams+n+instrumentsSave;
  }

  mxOut = mxCreateSparse(n,m,size,mxREAL);

  Ir = mxGetIr(mxOut);
  Jc = mxGetJc(mxOut);

  for(i=0;i<=m;i++) {
    Jc[i]=Jcd[i];
  }
  for(i=0;i<size;i++) {
    Ir[i]=Ird[i];
  }


  /* Compute */
  target = mxGetPr(mxOut);
  output = (double *) mxMalloc(size*sizeof(double));
  augmentedJacobian(output, arg);
  for(i=0;i<size;i++) {
    if((int) T[i]>size) {
      printf("%d, %d\n",T);
    }
    target[(int) T[i]]=output[i];
  }

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }

  strncpy(filename, argv[2], NAME_LENGTH);

  if ((mfp = matOpen(filename, "w")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }
  matPutVariable(mfp, "output", mxOut);
  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }
}
