void cleanup(void) {
  int i;
  int data_size = dataMex->index[problemMex->date*problemMex->market];

  initialized=0;

  mxFree(dataMex->index);

  mxFree(dataMex->jacobianIndex);

  for(i=0;i<data_size;++i) {
    mxFree(dataMex->data[i]);
  }
  mxFree(dataMex->data);

  if(problemMex->doInstruments==1) {
    for(i=0;i<problemMex->instruments;++i) {
      mxFree(dataMex->instruments[i]);
    }
    mxFree(dataMex->instruments);
    if(problemMex->ar) {
      mxFree(lag);
    }
  }

  for(i=0;i<problemMex->date*problemMex->market*problemMex->N;++i) {
    mxFree(dataMex->demographics[i]);
  }
  mxFree(dataMex->demographics);

  for(i=0;i<problemMex->date*problemMex->demoGroups*problemMex->P;++i) {
    mxFree(dataMex->demoGroups[i]);
  }

  if(problemMex->subsampling) {
    mxFree(dataMex->subsample);
  }

  mxFree(dataMex->demoGroups);

  mxFree(dataMex->share);
  mxFree(dataMex->demoFromData);

  mxFree(dataMex);
  mxFree(problemMex);
}

void loadData(const mxArray *prhs[]) {
  int i,j,m;
  int date_market, data_size;
  F_TYPE *dataInit;
  F_TYPE *demographicsInit;
  F_TYPE *demoGroupsInit;
  F_TYPE *instrumentsInit;
  F_TYPE *indexInit;
  F_TYPE *jacobianIndexInit;

  F_TYPE *shareInit, *demoFromDataInit;
  int lagSize;
  F_TYPE *lagInit;

  reInit = (int) mxGetPr(mxGetField(prhs[0], 0, "reInit"))[0];
  if((reInit) && (initialized)) {
    cleanup();
  }

  if((!initialized) || (reInit)) {
    printf("Initing ");
    initialized=1;
    problemMex = (BLPproblem *) mxMalloc(sizeof(BLPproblem));
    mexMakeMemoryPersistent(problemMex);
    mexAtExit(cleanup);
  

    /* Initialize problem structure */

    problemMex->market=(int) mxGetPr(mxGetField(prhs[0], 0, "market"))[0];
    problemMex->date=(int) mxGetPr(mxGetField(prhs[0], 0, "date"))[0];
    problemMex->product=(int) mxGetPr(mxGetField(prhs[0], 0, "product"))[0];
    problemMex->demoCharacteristics=(int) mxGetPr(mxGetField(prhs[0], 0, "demoCharacteristics"))[0];
    problemMex->demoGroups=(int) mxGetPr(mxGetField(prhs[0], 0, "demoGroups"))[0];
    problemMex->parameters=(int) mxGetPr(mxGetField(prhs[0], 0, "parameters"))[0];
    problemMex->P=(int) mxGetPr(mxGetField(prhs[0], 0, "P"))[0];
    problemMex->Pn=(int) mxGetPr(mxGetField(prhs[0], 0, "Pn"))[0];
    problemMex->N=(int) mxGetPr(mxGetField(prhs[0], 0, "N"))[0];
    problemMex->random_effects=(int) mxGetPr(mxGetField(prhs[0], 0, "random_effects"))[0];
    problemMex->power=problemMex->parameters+problemMex->product*(problemMex->demoCharacteristics)+problemMex->random_effects;
    int power = (int) mxGetPr(mxGetField(prhs[0], 0, "extra_parameters"))[0];
    problemMex->year_dummies=problemMex->parameters+problemMex->product*(problemMex->demoCharacteristics)+problemMex->random_effects+
      power;
    problemMex->number_of_year_dummies = (int) mxGetPr(mxGetField(prhs[0], 0, "year_dummies"))[0];
    problemMex->allParams=problemMex->parameters+problemMex->product*(problemMex->demoCharacteristics)+
      problemMex->random_effects+power+problemMex->number_of_year_dummies;
    problemMex->doInstruments=(int) mxGetPr(mxGetField(prhs[0], 0, "doInstruments"))[0];
    if(problemMex->doInstruments==1) {
      problemMex->instruments=(int) mxGetPr(mxGetField(prhs[0], 0, "instruments"))[0];
      instrumentsSave = problemMex->instruments;
    } else {
      instrumentsSave = (int) mxGetPr(mxGetField(prhs[0], 0, "instruments"))[0];
      problemMex->instruments=0;
    }
    problemMex->ar=(int) mxGetPr(mxGetField(prhs[0], 0, "ar"))[0];

    problemMex->bs=(int) mxGetPr(mxGetField(prhs[0], 0, "bs"))[0];
 
    problemMex->R=(int) mxGetPr(mxGetField(prhs[0], 0, "R"))[0];

    dataMex = (BLPdata *) mxMalloc(sizeof(BLPdata));
    mexMakeMemoryPersistent(dataMex);

    problemMex->subsampling=(int) mxGetPr(mxGetField(prhs[0], 0, "subsampling"))[0];
    if(problemMex->subsampling) {
      dataMex->subsample = (int *) mxMalloc(10*sizeof(int));
      mexMakeMemoryPersistent(dataMex->subsample);
      jacobianIndexInit = mxGetPr(mxGetField(prhs[1], 0, "subsample"));
      for(i=0;i<problemMex->subsampling;++i) {
        dataMex->subsample[i] = (int) jacobianIndexInit[i];
      }
    }

    date_market=problemMex->market*problemMex->date;

    problemMex->dataLineSize=(int) mxGetPr(mxGetField(prhs[0], 0, "dataLineSize"))[0];;
    problemMex->groupsLineSize=(int) mxGetPr(mxGetField(prhs[0], 0, "groupsLineSize"))[0];;
    problemMex->demoLineSize=(int) mxGetPr(mxGetField(prhs[0], 0, "demoLineSize"))[0];;

    /* Transfer data into the device */
    indexInit = mxGetPr(mxGetField(prhs[1], 0, "index"));
    dataMex->index = (int *) mxMalloc((date_market+1)*sizeof(int));
    mexMakeMemoryPersistent(dataMex->index);
    for(i=0;i<=date_market;++i) {
      dataMex->index[i] = (int) indexInit[i];
    }

    data_size = indexInit[date_market];
  
    jacobianIndexInit = mxGetPr(mxGetField(prhs[1], 0, "jacobianIndex"));
    dataMex->jacobianIndex = (int *) mxMalloc((date_market+1)*sizeof(int));
    mexMakeMemoryPersistent(dataMex->jacobianIndex);
    for(i=0;i<=date_market;++i) {
      dataMex->jacobianIndex[i] = (int) jacobianIndexInit[i];
    }

    dataInit = mxGetPr(mxGetField(prhs[1], 0, "data"));
    dataMex->data = (F_TYPE **) mxMalloc(data_size*sizeof(F_TYPE *));
    mexMakeMemoryPersistent(dataMex->data);
    m=0;
    for(i=0;i<data_size;++i) {
      dataMex->data[i] = (F_TYPE *) mxMalloc(problemMex->dataLineSize*sizeof(F_TYPE));
      mexMakeMemoryPersistent(dataMex->data[i]);
      for(j=0;j<problemMex->dataLineSize;++j) {
        dataMex->data[i][j]=dataInit[m];
        m++;
      }
    }

    if(problemMex->R==0) { /* Load demographics draws only no bootstraping */
      demographicsInit = mxGetPr(mxGetField(prhs[1], 0, "demographics"));
      dataMex->demographics = (F_TYPE **) mxMalloc(date_market*problemMex->N*sizeof(F_TYPE *));
      mexMakeMemoryPersistent(dataMex->demographics);
      m=0;
      for(i=0;i<date_market*problemMex->N;++i) {
        dataMex->demographics[i] = (F_TYPE *) mxMalloc(problemMex->demoLineSize*sizeof(F_TYPE));
        mexMakeMemoryPersistent(dataMex->demographics[i]);
        for(j=0;j<problemMex->demoLineSize;++j) {
          dataMex->demographics[i][j]=demographicsInit[m];
          m++;
        }
      } 
    } /* If bootstraping we need to load the whole pool since we will drawing from it, it is done in the simulateMex */
/*
    demoGroupsInit = mxGetPr(mxGetField(prhs[1], 0, "demoGroups"));
    dataMex->demoGroups = (F_TYPE **) mxMalloc(problemMex->date*problemMex->demoGroups*problemMex->P*sizeof(F_TYPE *));
    mexMakeMemoryPersistent(dataMex->demoGroups);
    m=0;
    for(i=0;i<problemMex->date*problemMex->demoGroups*problemMex->P;++i) {
      dataMex->demoGroups[i] = (F_TYPE *) mxMalloc(problemMex->groupsLineSize*sizeof(F_TYPE));
      mexMakeMemoryPersistent(dataMex->demoGroups[i]);
      for(j=0;j<problemMex->groupsLineSize;++j) {
        dataMex->demoGroups[i][j]=demoGroupsInit[m];
        m++;
      }
    }
*/
    shareInit = mxGetPr(mxGetField(prhs[1], 0, "share"));
    dataMex->share = (F_TYPE *) mxMalloc(data_size*sizeof(F_TYPE));
    mexMakeMemoryPersistent(dataMex->share);
    for(i=0;i<data_size;++i) {
      dataMex->share[i] = shareInit[i];
    } 

    demoFromDataInit = mxGetPr(mxGetField(prhs[1], 0, "demoFromData"));
    dataMex->demoFromData = (F_TYPE *) mxMalloc(problemMex->product*problemMex->demoGroups*sizeof(F_TYPE));
    mexMakeMemoryPersistent(dataMex->demoFromData);
    for(i=0;i<problemMex->product*problemMex->demoGroups;++i) {
      dataMex->demoFromData[i] = demoFromDataInit[i];
    }
  
    if(problemMex->doInstruments==1) {
      instrumentsInit = mxGetPr(mxGetField(prhs[1], 0, "instruments"));
      dataMex->instruments = (F_TYPE **) mxMalloc(problemMex->instruments*sizeof(F_TYPE *));
      mexMakeMemoryPersistent(dataMex->instruments);
      m=0;
      for(i=0;i<problemMex->instruments;++i) {
        dataMex->instruments[i] = (F_TYPE *) mxMalloc(data_size*sizeof(F_TYPE));
        mexMakeMemoryPersistent(dataMex->instruments[i]);
        for(j=0;j<data_size;++j) {
          dataMex->instruments[i][j]=instrumentsInit[m];
          m++;
        }
      }
      if(problemMex->ar) {
        lagInit = mxGetPr(mxGetField(prhs[1], 0, "lag"));
        lagSize = mxGetN(mxGetField(prhs[1], 0, "lag"));
        lag = (int *) mxMalloc(data_size*sizeof(int *));
        mexMakeMemoryPersistent(lag);
        for(i=0,j=0;i<lagSize;++i,j+=2) {
          lag[(int) lagInit[j]]=lagInit[j+1];
        }
      }
    }
    printf("done...\n");
  }
  if(problemMex->bs) {
    dataMex->bsDraws=mxGetPr(mxGetField(prhs[1], 0, "bsDraws"));
  }
}
