#define NAME_LENGTH 30
#include<string.h>
#include<mat.h>

mxArray *readvar(MATFile *mfp, const char *var_name);

void loadData(int argc, char *argv[]) {
  int i,j,m;
  int date_market, data_size;
  F_TYPE *dataInit;
  F_TYPE *demographicsInit;
  F_TYPE *demoGroupsInit;
  F_TYPE *instrumentsInit;
  F_TYPE *indexInit;
  F_TYPE *jacobianIndexInit;

  F_TYPE *shareInit, *demoFromDataInit;
  int lagSize;
  F_TYPE *lagInit;

  mxArray *var;

  if(argc<3) {
    printf("The executable needs two arguments: output and input .mat file names\n");
    exit(1);
  }

  char filename[NAME_LENGTH];
  MATFile *mfp;

  strncpy(filename, argv[1], NAME_LENGTH);

  if ((mfp = matOpen(filename, "r")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  problemMex = (BLPproblem *) mxMalloc(sizeof(BLPproblem));
  

  /* Initialize problem structure */
  var = readvar(mfp,"problem");

  problemMex->market=(int) mxGetPr(mxGetField(var, 0, "market"))[0];
  problemMex->date=(int) mxGetPr(mxGetField(var, 0, "date"))[0];
  problemMex->product=(int) mxGetPr(mxGetField(var, 0, "product"))[0];
  problemMex->demoCharacteristics=(int) mxGetPr(mxGetField(var, 0, "demoCharacteristics"))[0];
  problemMex->demoGroups=(int) mxGetPr(mxGetField(var, 0, "demoGroups"))[0];
  problemMex->parameters=(int) mxGetPr(mxGetField(var, 0, "parameters"))[0];
  problemMex->P=(int) mxGetPr(mxGetField(var, 0, "P"))[0];
  problemMex->Pn=(int) mxGetPr(mxGetField(var, 0, "Pn"))[0];
  problemMex->N=(int) mxGetPr(mxGetField(var, 0, "N"))[0];
  problemMex->random_effects=(int) mxGetPr(mxGetField(var, 0, "random_effects"))[0];
  problemMex->power=problemMex->parameters+problemMex->product*(problemMex->demoCharacteristics)+problemMex->random_effects;
  int power = (int) mxGetPr(mxGetField(var, 0, "extra_parameters"))[0];
  problemMex->year_dummies=problemMex->parameters+problemMex->product*(problemMex->demoCharacteristics)+problemMex->random_effects+
    power;
  problemMex->number_of_year_dummies = (int) mxGetPr(mxGetField(var, 0, "year_dummies"))[0];
  problemMex->allParams=problemMex->parameters+problemMex->product*(problemMex->demoCharacteristics)+
    problemMex->random_effects+power+problemMex->number_of_year_dummies;
  problemMex->doInstruments=(int) mxGetPr(mxGetField(var, 0, "doInstruments"))[0];
  if(problemMex->doInstruments==1) {
    problemMex->instruments=(int) mxGetPr(mxGetField(var, 0, "instruments"))[0];
    instrumentsSave = problemMex->instruments;
  } else {
    instrumentsSave = (int) mxGetPr(mxGetField(var, 0, "instruments"))[0];
    problemMex->instruments=0;
  }
  problemMex->ar=(int) mxGetPr(mxGetField(var, 0, "ar"))[0];

  problemMex->bs=(int) mxGetPr(mxGetField(var, 0, "bs"))[0];

  problemMex->R=(int) mxGetPr(mxGetField(var, 0, "R"))[0];

  problemMex->subsampling=(int) mxGetPr(mxGetField(var, 0, "subsampling"))[0];

  dataMex = (BLPdata *) mxMalloc(sizeof(BLPdata));


  problemMex->dataLineSize=(int) mxGetPr(mxGetField(var, 0, "dataLineSize"))[0];
  problemMex->groupsLineSize=(int) mxGetPr(mxGetField(var, 0, "groupsLineSize"))[0];
  problemMex->demoLineSize=(int) mxGetPr(mxGetField(var, 0, "demoLineSize"))[0];

  var = readvar(mfp,"data");

  if(problemMex->subsampling) {
    dataMex->subsample = (int *) mxMalloc(10*sizeof(int));
    jacobianIndexInit = mxGetPr(mxGetField(var, 0, "subsample"));
    for(i=0;i<problemMex->subsampling;++i) {
      dataMex->subsample[i] = (int) jacobianIndexInit[i];
    }
  }

  date_market=problemMex->market*problemMex->date;

  /* Transfer data into the device */
  indexInit = mxGetPr(mxGetField(var, 0, "index"));
  dataMex->index = (int *) mxMalloc((date_market+1)*sizeof(int));
  for(i=0;i<=date_market;++i) {
    dataMex->index[i] = (int) indexInit[i];
  }

  data_size = indexInit[date_market];

  jacobianIndexInit = mxGetPr(mxGetField(var, 0, "jacobianIndex"));
  dataMex->jacobianIndex = (int *) mxMalloc((date_market+1)*sizeof(int));
  for(i=0;i<=date_market;++i) {
    dataMex->jacobianIndex[i] = (int) jacobianIndexInit[i];
  }

  dataInit = mxGetPr(mxGetField(var, 0, "data"));
  dataMex->data = (F_TYPE **) mxMalloc(data_size*sizeof(F_TYPE *));
  m=0;
  for(i=0;i<data_size;++i) {
    dataMex->data[i] = (F_TYPE *) mxMalloc(problemMex->dataLineSize*sizeof(F_TYPE));
    for(j=0;j<problemMex->dataLineSize;++j) {
      dataMex->data[i][j]=dataInit[m];
      m++;
    }
  }

  if(problemMex->R==0) { /* Load demographics draws only no bootstraping */
    demographicsInit = mxGetPr(mxGetField(var, 0, "demographics"));
    dataMex->demographics = (F_TYPE **) mxMalloc(date_market*problemMex->N*sizeof(F_TYPE *));
    m=0;
    for(i=0;i<date_market*problemMex->N;++i) {
      dataMex->demographics[i] = (F_TYPE *) mxMalloc(problemMex->demoLineSize*sizeof(F_TYPE));
      for(j=0;j<problemMex->demoLineSize;++j) {
        dataMex->demographics[i][j]=demographicsInit[m];
        m++;
      }
    } 
  } /* If bootstraping we need to load the whole pool since we will drawing from it, it is done in the simulateMex */
/*
  demoGroupsInit = mxGetPr(mxGetField(var, 0, "demoGroups"));
  dataMex->demoGroups = (F_TYPE **) mxMalloc(problemMex->date*problemMex->demoGroups*problemMex->P*sizeof(F_TYPE *));
  m=0;
  for(i=0;i<problemMex->date*problemMex->demoGroups*problemMex->P;++i) {
    dataMex->demoGroups[i] = (F_TYPE *) mxMalloc(problemMex->groupsLineSize*sizeof(F_TYPE));
    for(j=0;j<problemMex->groupsLineSize;++j) {
      dataMex->demoGroups[i][j]=demoGroupsInit[m];
      m++;
    }
  }
*/
  shareInit = mxGetPr(mxGetField(var, 0, "share"));
  dataMex->share = (F_TYPE *) mxMalloc(data_size*sizeof(F_TYPE));
  for(i=0;i<data_size;++i) {
    dataMex->share[i] = shareInit[i];
  } 

  demoFromDataInit = mxGetPr(mxGetField(var, 0, "demoFromData"));
  dataMex->demoFromData = (F_TYPE *) mxMalloc(problemMex->product*problemMex->demoGroups*sizeof(F_TYPE));
  for(i=0;i<problemMex->product*problemMex->demoGroups;++i) {
    dataMex->demoFromData[i] = demoFromDataInit[i];
  }

  if(problemMex->doInstruments==1) {
    instrumentsInit = mxGetPr(mxGetField(var, 0, "instruments"));
    dataMex->instruments = (F_TYPE **) mxMalloc(problemMex->instruments*sizeof(F_TYPE *));
    m=0;
    for(i=0;i<problemMex->instruments;++i) {
      dataMex->instruments[i] = (F_TYPE *) mxMalloc(data_size*sizeof(F_TYPE));
      for(j=0;j<data_size;++j) {
        dataMex->instruments[i][j]=instrumentsInit[m];
        m++;
      }
    }
    if(problemMex->ar) {
      lagInit = mxGetPr(mxGetField(var, 0, "lag"));
      lagSize = mxGetN(mxGetField(var, 0, "lag"));
      lag = (int *) mxMalloc(data_size*sizeof(int *));
      for(i=0,j=0;i<lagSize;++i,j+=2) {
        lag[(int) lagInit[j]]=lagInit[j+1];
      }
    }
  }

  if(problemMex->bs) {
    dataMex->bsDraws=mxGetPr(mxGetField(var, 0, "bsDraws"));
  }
}

mxArray *readvar(MATFile *mfp, const char *var_name) {
    mxArray *array_ptr;
    int *from, *to;

    if ((array_ptr = matGetVariable(mfp, var_name)) == NULL) {
        printf("Cannot read matlab variable %s", var_name);
        exit(1);
    }
    if ((mxGetNumberOfElements(array_ptr) == 1) && mxIsNumeric(array_ptr)) {
      #ifdef COUT_DEBUG
        printf("Reading matlab variable %s = %d\n",var_name, mxGetScalar(array_ptr));
      #endif
    } else {
        #ifdef COUT_DEBUG
          printf("Reading matlab variable %d (",var_name);
        #endif
        from = (int *) mxGetDimensions(array_ptr);
        to = from+mxGetNumberOfDimensions(array_ptr)-1;
        for (; from<to; from++) {
        #ifdef COUT_DEBUG
          printf("%dx",*from);
        #endif
        }
        #ifdef COUT_DEBUG
          printf("%d)\n",*from);
        #endif
    }

    return array_ptr;
}
