#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>
#include <simulation.h>

#include <mex.h>

static int initialized = 0;
static BLPproblem *problemMex;
static BLPdata *dataMex;

#include<loadData.c>

void mexFunction(int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[]) { 
  int i,m,j,height,d,offset,z,i1;
  int date_market, data_size;
  double *arg, *argInit, *mySeedInit;
  int argSize;
  double *output, *nu, *output2;
  double *demPool;
  double var, vare, varb, varfs;
  int var_n,vare_n,varb_n,varfs_n;
  int demPoolSize;

  loadData(prhs);

  problem=problemMex;
  data=dataMex;

  date_market=problem->market*problem->date;
  data_size = data->index[date_market];
  threadsN = problem->market*problem->date+problem->demoGroups*problem->date;

  /* Initialize random number generator */
  mySeedInit = mxGetPr(prhs[2]);
  mySeed = (long *) mxMalloc(4*sizeof(long));
  mySeed[0] = (long) mySeedInit[0];
  mySeed[1] = (long) mySeedInit[1];
  mySeed[2] = (long) mySeedInit[2];
  mySeed[3] = (long) mySeedInit[3];

  seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

  createGenerators(threadsN, mySeed, seed);

  /* Load the starting point */
  argInit = mxGetPr(prhs[3]);
  argSize = mxGetM(prhs[3]);
  arg = (F_TYPE *) mxMalloc(argSize*sizeof(F_TYPE));
  for(i=0;i<problem->allParams;++i) {
    arg[i]=argInit[i];
  }

  if(problem->ar==1) {
    arg[argSize-1]=argInit[argSize-1];
  }
  printf("Estimate variance:\n");
  height=data->index[problem->market*problem->date]+problem->demoGroups*problem->product;

  plhs[1]=mxCreateDoubleMatrix(data_size, 1, mxREAL);
  nu = mxGetPr(plhs[1]);

  /* Estimate the variance of the innovation */
  if(problem->ar) {
    var=0;
    vare=0;
    var_n=0;
    vare_n=0;
    varb=0;
    varb_n=0;
    varfs=0;
    varfs_n=0;
    for(i=0;i<data->index[problem->market];++i) {
      nu[i]=argInit[problem->allParams+i];
      varb+=nu[problem->allParams+i]*nu[problem->allParams+i];
      varb_n++;
    }
    for(i=data->index[problem->market];i<data_size;++i) {
      if(lag[i]>-1) {
        nu[i]=argInit[problem->allParams+i]-argInit[argSize-1]*argInit[problem->allParams+lag[i]];

        if(data->data[lag[i]][2]!=data->data[i][2]) {
          varfs+=nu[i]*nu[i];
          varfs_n++;
        } else {
          var+=nu[i]*nu[i];
          var_n++;
        }
      } else {
        vare+=nu[i]*nu[i];
        vare_n++;
      }
    }
    var=sqrt(var/var_n);
    vare=sqrt(vare/vare_n);
    varb=sqrt(varb/varb_n);
    varfs=sqrt(varfs/varfs_n);
    printf("Variance estimates: %f,%f,%f,%f\n", varb, var, varfs, vare);
  } else {
    var=0;
    nu[i]=argInit[problem->allParams+i];
    for(i=0;i<data_size;++i) {
      var+=nu[i]*nu[i];
    }
    var=sqrt(var/data_size);
    printf("Variance estimates: %f\n", var);
  }

  plhs[1]=mxCreateDoubleMatrix(data_size, 1, mxREAL);
  nu = mxGetPr(plhs[1]);

  /* Normalize the innovations to get the emprirical distribution of nu */
  if(problem->ar==1) {
    for(i=0;i<data->index[problem->market];++i) {
      nu[i]/=varb;
    }
    for(i=data->index[problem->market];i<data_size;++i) {
      if(lag[i]>-1) {
        if(data->data[lag[i]][2]!=data->data[i][2]) {
          nu[i]/=varfs;
        } else {
          nu[i]/=var;
        }
      } else {
        nu[i]/=vare;
      }
    }
  }

  
  /* Run optimization */
  
  demPool = mxGetPr(mxGetField(prhs[1], 0, "demPool"));
  demPoolSize = (int) mxGetPr(mxGetField(prhs[0], 0, "demPoolSize"))[0];

  plhs[0]=mxCreateDoubleMatrix(height, problem->R, mxREAL);
  output = mxGetPr(plhs[0]);
  plhs[2]=mxCreateDoubleMatrix(problem->allParams+data->index[problem->market*problem->date], problem->R, mxREAL);
  output2 = mxGetPr(plhs[2]); 

  data->demographics = (F_TYPE **) mxMalloc(date_market*problem->N*sizeof(F_TYPE *));
  for(i=0;i<problem->date*problem->market*problemMex->N;++i) {
    data->demographics[i] = (F_TYPE *) mxMalloc(problem->demoLineSize*sizeof(F_TYPE));
  }


  printf("Lag: %f\n",arg[argSize-1]);
  for(i=0;i<problem->R;++i) {
    printf("Simulation %d",i);
    /* Generate new demographics draws */
    m=0;
    for(d=0;d<problem->date*problem->market;++d) {
      offset = d*demPoolSize*problem->demoLineSize;
      for(i1=0;i1<problem->N;++i1) {
        z = (int) (demPoolSize*nextUniform(seed[0]));
        z = z*problem->demoLineSize+offset;
        for(j=0;j<problem->demoLineSize;++j) {
          data->demographics[m][j]=demPool[z+j];
        }
        m++;
      }
    } 

    /* Generate xi's */
    if(problem->ar==1) {
      /* Starting value */
      for(j=0;j<data->index[problem->market];++j) {
        arg[problem->allParams+j]=varb*nu[(int) (data_size*nextUniform(seed[0]))];
      }
      /* Innovations */
      for(j=data->index[problem->market];j<data_size;++j) {
        if(lag[j]>-1) {
          if(data->data[lag[j]][2]!=data->data[j][2]) {
            arg[problem->allParams+j]=varfs*nu[(int) (data_size*nextUniform(seed[0]))];
          } else {
            arg[problem->allParams+j]=var*nu[(int) (data_size*nextUniform(seed[0]))];
          }
        } else {
          arg[problem->allParams+j]=vare*nu[(int) (data_size*nextUniform(seed[0]))];
        }
      }

      /* Lags */
      for(j=data->index[problem->market];j<data->index[problem->market*problem->date];++j) {
        if(lag[j]>-1) {
          arg[problem->allParams+j]+=arg[argSize-1]*arg[problem->allParams+lag[j]];
        }
      } 
    } else {
      vectorNormalVar(seed[0],data->index[problem->market*problem->date],arg+problem->allParams,var);
    }

    for(j=0;j<problem->allParams+data->index[problem->market*problem->date];++j) {
      *output2=arg[j];
      output2++;
    }

/*    for(j=0;j<data->index[problem->market*problem->date];j++) {
      printf("%f ",arg[problem->allParams+j]);
    }
    getchar();*/

    /* Run simulations */
    augmentedSimulation(output, arg);
    output+=height;
    printf(" done ...\n");
  }
}
