#include<cuda_generator.h>
#include<stdlib.h>
#include<stdio.h>
#include<csvread.h>
#include<setup.h>
#include<math.h>

#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

#include <blp.h>

#include <mex.h>

static int initialized = 0;
static BLPproblem *problemMex;
static BLPdata *dataMex;

#include<loadDataBin.c>

int main(int argc, char *argv[]) {
  int i,m,j,date,c;
  int date_market, data_size;
  F_TYPE *output;
  double *argInit, *output2, *xi;
  int nu1,iter;
  double temp;
  double norm;
  int start, argSize;
  double *mySeedInit, *arg;
  mxArray *mxOut;

  loadData(argc,argv);

  if(argc<3) {
    printf("The executable needs two arguments: output and input .mat file names\n");
    exit(1);
  }

  char filename[NAME_LENGTH];
  MATFile *mfp;

  strncpy(filename, argv[1], NAME_LENGTH);

  if ((mfp = matOpen(filename, "r")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  problem=problemMex;
  data=dataMex;

  date_market=problem->market*problem->date;
  data_size = data->index[date_market];
  threadsN = problem->market*problem->date;

  /* Initialize random number generator */
  mySeedInit = mxGetPr(readvar(mfp,"mySeed"));
  seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

  if(!problem->bs) {
    mySeed = (long *) mxMalloc(4*sizeof(long));
    mySeed[0] = (long) mySeedInit[0];
    mySeed[1] = (long) mySeedInit[1];
    mySeed[2] = (long) mySeedInit[2];
    mySeed[3] = (long) mySeedInit[3];
  }

  /* Load the starting point */
  argInit = mxGetPr(readvar(mfp,"arg"));
  argSize = mxGetM(readvar(mfp,"arg"));

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }

  arg = (double *) mxMalloc(argSize*sizeof(F_TYPE));
  for(i=0;i<problem->allParams+data->index[date_market];i++) {
    arg[i] = argInit[i];
  }
  for(i=problem->allParams+data->index[date_market];i<argSize-1;++i) {
    arg[i] = 0;
  }
  if(problem->ar) {
    arg[argSize-1]=argInit[argSize-1];
  } else {
    arg[argSize-1]=0;
  }

  if(problem->bs) {
    createGeneratorsSaved(threadsN, mySeedInit, seed);
  } else {
    createGenerators(threadsN, mySeed, seed);
  }
  

  norm = 1;
  output2 = (F_TYPE *) mxMalloc((data->index[date_market]+problem->date*problem->market*problem->demoGroups*problem->product+problem->instruments)*sizeof(F_TYPE));
  xi = arg+problem->allParams;
  iter=0;
  while((norm>1e-1) && (iter<1e16)) {
    printf("%f\n",norm);
    if(problem->bs) {
      createGeneratorsSaved(threadsN, mySeedInit, seed);
    } else {
      createGenerators(threadsN, mySeed, seed);
    }

    for(i=0;i<problem->date*problem->market;i++) {
      constraint(output2, arg, problem, data, seed, date_market, i);
    }
    norm=0;
    for(i=0;i<data->index[date_market];i++) {
      temp=log(data->share[i])-log(output2[i]);
      if(fabs(temp)>norm)
        norm=fabs(temp);
      xi[i] = xi[i]+temp;
    }
    iter++;
  }

  if(problem->bs) {
    createGeneratorsSaved(threadsN, mySeedInit, seed);
  } else {
    createGenerators(threadsN, mySeed, seed);
  }

  augmentedConstraint(output2, arg);
  
  if(problem->subsampling) {
    date=0;
    c=0;
    for(i=data->index[problem->market];i<data->index[date_market];i++) {
      if(i>=data->index[problem->market*date]) {
        date++;
      }
      if(!search(data->subsample,date)) {
        continue;
      }
      c++;
    }
  } else {
    c=data->index[date_market]-data->index[problem->market];
  }

  for(i=0;i<problem->instruments;i++) {
    if(problem->ar) {
      arg[problem->allParams+data->index[date_market]+problem->demoGroups*problem->product+i]=
        output2[data->index[date_market]+problem->demoGroups*problem->product+i]/c;
    } else {
      arg[problem->allParams+data->index[date_market]+problem->demoGroups*problem->product+i]=
        output2[data->index[date_market]+problem->demoGroups*problem->product+i]/data->index[date_market];
    }
  }
  for(i=0;i<problem->demoGroups*problem->product;i++) {
    arg[problem->allParams+data->index[date_market]+i]=output2[data->index[date_market]+i];
  }

  mxOut=mxCreateDoubleMatrix(argSize, 1, mxREAL);
  argInit = mxGetPr(mxOut);
  for(i=0;i<argSize;i++) {
    argInit[i]=arg[i];
  }

  strncpy(filename, argv[2], NAME_LENGTH);

  if ((mfp = matOpen(filename, "w")) == NULL) {
    printf("Cannot open MAT-file %s\n", filename);
    exit(1);
  } else {
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", filename);
    #endif
  }

  matPutVariable(mfp, "x_0", mxOut);

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n",filename);
    return(EXIT_FAILURE);
  }
}
